

<?php $__env->startSection('title', 'Students'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('students.index')); ?>">Students</a></li>
    <li class="breadcrumb-item active">Details</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        // Get current active class detail
        $currentClass = $student->classDetails->first();
    ?>

    <div id="students-page" class="page-content">
        <h1 class="mb-4">Student Management</h1>
        <div class="card">

            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Student Details</h5>

                <div class="d-flex gap-2">
                    <a href="<?php echo e(route('students.edit', $student->id)); ?>" class="btn btn-sm btn-primary">
                        Edit
                    </a>
                    <a href="<?php echo e(route('students.index')); ?>" class="btn btn-sm btn-secondary">
                        Back
                    </a>
                </div>
            </div>

            <div class="card-body">

                
                <h6 class="text-muted mb-3">Personal Information</h6>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Admission No:</strong> <?php echo e($student->admission_no); ?></div>
                    <div class="col-md-3"><strong>DOA:</strong> <?php echo e($student->created_at); ?></div>
                    <div class="col-md-3">
                        <strong>Status:</strong>
                        <span class="badge <?php echo e($student->status ? 'bg-success':'bg-danger'); ?>">
                            <?php echo e($student->status ? 'Active' : 'Inactive'); ?>

                        </span>
                    </div>
                </div>
                <div class="row mb-3">
                    
                    <div class="col-md-12"><strong>Name:</strong> <?php echo e($student->name); ?></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3"><strong>DOB:</strong> <?php echo e($student->dob); ?></div>
                    <div class="col-md-3"><strong>Gender:</strong> <?php echo e($student->gender); ?></div>
                    <div class="col-md-3"><strong>Nationality:</strong> <?php echo e($student->nationality); ?></div>
                    <div class="col-md-3"><strong>Mother Tongue:</strong> <?php echo e($student->mother_tongue); ?></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3"><strong>Category:</strong> <?php echo e($student->category); ?></div>
                    <div class="col-md-3"><strong>Caste:</strong> <?php echo e($student->cast); ?></div>
                    <div class="col-md-3"><strong>Minority:</strong> <?php echo e($student->belongs_to_minority_group ? 'Yes':'No'); ?></div>
                    <div class="col-md-3"><strong>PH:</strong> <?php echo e($student->is_disability_ph ? 'Yes':'No'); ?></div>
                </div>

                
                <h6 class="text-muted mt-4 mb-3">Address</h6>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Permanent Address:</strong><br>
                        <?php echo e($student->address); ?>

                    </div>
                    <div class="col-md-6">
                        <strong>Local Address:</strong><br>
                        <?php echo e($student->local_address); ?>

                    </div>
                </div>

                
                <h6 class="text-muted mt-4 mb-3">Class Details</h6>

                <?php if($currentClass): ?>
                <div class="row mb-3">
                    <div class="col-md-3"><strong>Class:</strong> <?php echo e($currentClass->class->class_name); ?></div>
                    <div class="col-md-3"><strong>Section:</strong> <?php echo e($currentClass->section->section_name); ?></div>
                    <div class="col-md-3"><strong>Roll No:</strong> <?php echo e($currentClass->roll_no); ?></div>
                    <div class="col-md-3">
                        <strong>Academic Year:</strong>
                        <?php echo e($currentClass->financialYear->label); ?>

                    </div>
                </div>
                <?php endif; ?>

                
                <h6 class="text-muted mt-4 mb-3">Parent / Guardian Details</h6>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Father Name:</strong> <?php echo e($student->parent->father_name); ?></div>
                    <div class="col-md-6"><strong>Mother Name:</strong> <?php echo e($student->parent->mother_name); ?></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Father Occupation:</strong> <?php echo e($student->parent->father_occupation); ?></div>
                    <div class="col-md-6"><strong>Mother Occupation:</strong> <?php echo e($student->parent->mother_occupation); ?></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Father Phone:</strong> <?php echo e($student->parent->father_phone); ?></div>
                    <div class="col-md-6"><strong>Mother Phone:</strong> <?php echo e($student->parent->mother_phone); ?></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6"><strong>Guardian Name:</strong> <?php echo e($student->parent->guardian_name); ?></div>
                    <div class="col-md-6"><strong>Guardian Phone:</strong> <?php echo e($student->parent->guardian_phone); ?></div>
                </div>

                <div class="mb-3">
                    <strong>Guardian Address:</strong><br>
                    <?php echo e($student->parent->guardian_address); ?>

                </div>

                
                <h6 class="text-muted mt-4 mb-3">Documents</h6>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label><strong>Profile Photo</strong></label><br>
                        <?php if($student->profile_image): ?>
                            <img src="<?php echo e(asset('storage/'.$student->profile_image)); ?>"
                                class="img-thumbnail"
                                style="max-height:150px;">
                        <?php else: ?>
                            <span class="text-muted">Not Uploaded</span>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6">
                        <label><strong>DOB Proof</strong></label><br>
                        <?php if($student->dob_photo_copy): ?>
                            <a href="<?php echo e(asset('storage/'.$student->dob_photo_copy)); ?>"
                            class="btn btn-sm btn-outline-primary"
                            download>
                                Download DOB Proof
                            </a>
                        <?php else: ?>
                            <span class="text-muted">Not Uploaded</span>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\school\resources\views/students/show.blade.php ENDPATH**/ ?>